<?php
/**
 * E-Garçom - o aplicativo mais rápido do mercado
 * 
 * @class services
 * @package WebServices de Sincronia e Comunicação Socket - E-Garçom
 * @author Willian Nascimento <willian@ecletica.com.br>
 * @author Rafael Pelegrini   <rafael@ecletica.com.br>
 * @copyright Copyright (c) 2016, Eclética Informática
 * @version 1.13.0
 */
ini_set('display_errors', 'on');
error_reporting(E_ERROR);

//importa os componentes necessários
require_once( 'plataforma/nucleo.php' );
require_once( 'plataforma/negocio.php' );

class services extends negocio{
    
    /**
     * @var mixed
     */
    private $metodo, $host, $porta, $usuario, $senha, $nomebanco, $ip_socket, $porta_socket, $num_pocket,
            $operacao, $mesa, $comanda, $numero, $tipo_consulta, $id_venda, $mesa_comanda, $usa_checkin, $conn, $nome_arquivo, $debug=false, $qtde_pockets, $uuid, $operador, $plataforma, $version_api = "1.18.0";

        /* ||||||||||||||||||||||||||| Version Comments |||||||||||||||||||||||||||||||||||||
           
            #version_api --> 1.3.0
            # a versao 1.3.0 foi atualizada com um novo metodo para efetuar venda por integradores externos. Tal qual faz ate 3 novas tentativas recursivas de 20 em 20 segundos para forcar uma resposta do socket.

            #version_api --> 1.7.3
            # versao que foi compilada

            #version_api --> 1.7.4
            # Adicionada funcionalidade de adicao de produtos temporarios

            #version_api --> 1.8.0
            # Criado metodo que lista as justificativas de cancelamento e tambem se usa ou nao via metodo verificacoesIniciais

            #version_api --> 1.9.0
            # Envia dados shipay no metodo verificacoesIniciais

            #version_api --> 1.9.1
            # Ajustado campo cpf_cnpj_shipay na resposta e no banco de dados

            #version_api --> 1.10.0
            #Criado metodo que informa o IP do client para ser exibido na tela de configuracoes.
            Ajuste SELECT de combos para evitar que exiba produtos escondidos.
            
            #version_api --> 1.11.0
            #Enviando dados do TEF (chama_tef, cod_sitef) na listagem das bandeiras para o funcionamento do mSitef na conclusao dos pagamentos
            
            #version_api --> 1.12.0
            #Criado método para o PDV realizar impressoes diversas (principalmente para mSitef) e inserida permissoes de TEFAdministrativo para a lista de operadores

            #version_api --> 1.13.0
            #Adicionado dados exclusivos do OpenDelivery no método listaProdutos para Olga usar no toten 

            #version_api --> 1.14.0
            #Adicionado campos no método consultaItens para exibir nome do garçom entre outros.
            #Na listagem de produtos, verificando o parametro específico para ver se a loja filtra por INDOOR na exibiçao do item

            #version_api --> 1.15.0
            #Inserida novas verificaçòes no método verificacoesIniciais para controle de sistema de login via PDV do DM
            #Ainda nesta tarefa, criado novo metodo para verificar login e logoff do sistema de login via PDV do DM
            
            #version_api --> 1.15.1
            #Correçao de bug do parametro INDOOR que faltou para combos e pizzas; Ajuste na lista de produtos para obedecer a carga seletiva; 

            #version_api --> 1.16.1
            #Adicionado campo imagem na listagem de bandeiras para o sistema de botoes do E-Garcom Pro, ordenando-as no SELECT tambem pelo campo ordem_bandeira, descr_det
    
            #version_api --> 1.17.0
            #Adicionado dados das imagens p/ totens Olga. 
    
            #version_api --> 1.18.0
            #Adicionada colunas na tabela de combos para COMBOS POR ETAPAS e inseridas também método com Tipos de Desconto


            #version_api --> 1.19.0
            #Adicionado método de exibir produtos escondidos

           ||||||||||||||||||||||||| End Version Comments ||||||||||||||||||||||||||||||||||| */




    function __construct() {
        
        // Instancia a classe pai negocio com suas propriedades e métodos
        parent::__construct();

        // Alimenta as propriedades principais do WebService com dados vindos do GET
        $this->metodo        =  ( isset( $_GET['metodo'] ) )        ?   $_GET['metodo'] : '';
        $this->host          =  ( isset( $_GET['host'] ) )          ?   $_GET['host'] : '';
        $this->porta         =  ( isset( $_GET['porta'] ) )         ?   $_GET['porta'] : '';
        $this->usuario       =  ( isset( $_GET['usuario'] ) )       ?   $_GET['usuario'] : '';
        $this->senha         =  ( isset( $_GET['senha'] ) )         ?   $_GET['senha'] : '';
        $this->nomebanco     =  ( isset( $_GET['nomebanco'] ) )     ?   $_GET['nomebanco'] : '';
        $this->ip_socket     =  ( isset( $_GET['ip_socket'] ) )     ?   $_GET['ip_socket'] : '';
        $this->porta_socket  =  ( isset( $_GET['porta_socket'] ) )  ?   $_GET['porta_socket'] : '';
        $this->num_pocket    =  ( isset( $_GET['num_pocket'] ) )    ?   $_GET['num_pocket'] : '';
        $this->qtde_pockets  =  ( isset( $_GET['qtde_pockets'] ) )  ?   $_GET['qtde_pockets'] : '';
        $this->uuid          =  ( isset( $_GET['uuid'] ) )          ?   $_GET['uuid'] : '';
        $this->plataforma    =  ( isset( $_GET['plataforma'] ) )    ?   $_GET['plataforma'] : '';
        $this->operador      =  ( isset( $_GET['operador'] ) )      ?   $_GET['operador'] : '';
        $this->operacao      =  ( isset( $_GET['operacao'] ) )      ?   $_GET['operacao'] : '';
        $this->mesa          =  ( isset( $_GET['mesa'] ) )          ?   $_GET['mesa'] : '';
        $this->comanda       =  ( isset( $_GET['comanda'] ) )       ?   $_GET['comanda'] : '';
        $this->mesa_comanda  =  ( isset( $_GET['mesa_comanda'] ) )  ?   $_GET['mesa_comanda'] : '';
        $this->num_origem    =  ( isset( $_GET['num_origem'] ) )    ?   $_GET['num_origem'] : '';
        $this->num_destino   =  ( isset( $_GET['num_destino'] ) )   ?   $_GET['num_destino'] : '';
        $this->numero        =  ( isset( $_GET['numero'] ) )        ?   $_GET['numero'] : '';
        $this->tipo_consulta =  ( isset( $_GET['tipo_consulta'] ) ) ?   $_GET['tipo_consulta'] : '';
        $this->usa_checkin   =  ( isset( $_GET['usa_checkin'] ) )   ?   $_GET['usa_checkin'] : '';
        $this->id_venda      =  ( isset( $_GET['id_venda'] ) )      ?   $_GET['id_venda'] : '';
        $this->nome_arquivo  =  ( isset( $_GET['nome_arquivo'] ) )  ?   $_GET['nome_arquivo'] : '';
        
        //formatar variaveis de conexao em um array
        $this->conn['host']         = $this->host;
        $this->conn['porta']        = $this->porta;
        $this->conn['usuario']      = $this->usuario;
        $this->conn['senha']        = $this->senha;
        $this->conn['nomebanco']    = $this->nomebanco;
        $this->conn['ip_socket']    = $this->ip_socket;
        $this->conn['porta_socket'] = $this->porta_socket;
        $this->conn['num_pocket']   = $this->num_pocket;
        
        //Verifica autenticação do loginToken no header da requisição
        $this->validaHash( $this->app->request()->headers->get( 'loginToken' ) );


        
        //Roteador de métodos via GET enviado pelo consumidor do Webservice 
        switch( $this->metodo )
        {
            case 'verificacoesIniciais':
                $this->_verificacoesIniciais( $this->app, $this->debug, $this->version_api );
                break;
            
            case 'listaGrupos':
                $this->_listaGrupos( $this->app, $this->conn, $this->num_pocket );
                break;
            
            case 'listaProdutos':
                $this->_listaProdutos( $this->app, $this->conn, $this->num_pocket );
                break;
            
            case 'listaProdutosEscondidos':
                $this->_listaProdutosEscondidos( $this->app, $this->conn, $this->num_pocket );
                break;
            
            case 'listaCombos':
                $this->_listaCombos( $this->app, $this->conn );
                break;

            case 'listaPizzas':
                $this->_listaPizzas( $this->app, $this->conn );
                break;
            
            case 'listaProdutosFaltantes':
                $this->_listaProdutosFaltantes( $this->app, $this->conn );
                break;
            
            case 'listaPromocoes':
                $this->_listaPromocoes( $this->app, $this->conn );
                break;
            
            case 'listaDetalheBandeiras':
                $this->_listaDetalheBandeiras( $this->app, $this->conn );
                break;
            
            case 'listaOperadores':
                $this->_listaOperadores( $this->app, $this->operacao, $this->conn );
                break;

            case 'listaJustificativasCancelamento':
                $this->_listaJustificativasCancelamento( $this->app, $this->conn );
                break;

            case 'listaTiposDeDesconto':
                $this->_listaTiposDeDesconto( $this->app, $this->conn );
                break;
            
            case 'listaTipoClientes':
                $this->_listaTipoClientes( $this->app, $this->conn );
                break;
            
            case 'efetuaVenda':
                $this->_efetuaVenda( $this->app, $this->conn );
                break;

            case 'fecharConta':
                $this->_fecharConta( $this->app, $this->conn );
                break;

            case 'chamarGarcom':
                $this->_chamarGarcom( $this->app, $this->conn );
                break;

            case 'consultaTotalConta':
                $this->_consultaTotalConta( $this->app, $this->conn );
                break;
            
            case 'cancelaVenda':
                $this->_cancelaVenda( $this->app, $this->id_venda, $this->conn );
                break;
            
            case 'consultaMesaPreFechamento':
                $this->_consultaMesaPreFechamento( $this->app, $this->mesa, $this->conn );
                break;
            
            case 'consultaComandaBloqueada':
                $this->_consultaComandaBloqueada( $this->app, $this->comanda, $this->usa_checkin, $this->conn );
                break;
            
            case 'mapaDeMesas':
                $this->_mapaDeMesas( $this->app, $this->conn );
                break;
            
            case 'mapaDeComandas':
                $this->_mapaDeComandas( $this->app, $this->conn );
                break;
            
            case 'enviaPreFechamento':
                $this->_enviaPreFechamento( $this->app, $this->conn, $this->operacao, $this->mesa_comanda );
                break;
            
            case 'listaProdutosVinculados':
                $this->_listaProdutosVinculados( $this->app, $this->conn );
                break;

            case 'listaProdutosTemporarios':
                $this->_listaProdutosTemporarios( $this->app, $this->conn );
                break;

            case 'consultaItens':
                $this->_consultaItens( $this->app, $this->conn, $this->operacao, $this->mesa_comanda );
                break;
            
            case 'cancelaItens':
                $this->_cancelaItens( $this->app, $this->conn, $this->operacao, $this->mesa_comanda );
                break;

            case 'cancelaRequisicaoMercadoPago':
                $this->_cancelaRequisicaoMercadoPago( $this->app, $this->conn);
                break;
            
            case 'transfereItens':
                $this->_transfereItens( $this->app, $this->conn, $this->operacao, $this->num_origem, $this->num_destino );
                break;
            
            case 'consultaCliente':
                $this->_consultaCliente( $this->app, $this->conn, $this->numero, $this->tipo_consulta );
                break;
            
            case 'consultaComandaCheckin':
                $this->_consultaComandaCheckin( $this->app, $this->conn, $this->comanda );
                break;

            case 'gravaTXT':
                $this->_gravaTXT( $this->app, $this->nome_arquivo, $this->conn );
                break;
        
            case 'gravaCheckin':
                $this->_gravaCheckin( $this->app, $this->conn);
                break;

            case 'getIP':
                $this->_getIP( $this->app );
                break;
                   
            case 'imprimeDiversosPDV':
                $this->_imprimeDiversosPDV( $this->app, $this->conn );
                break;

            case 'verificaLogin':
                $this->_verificaLogin( $this->app, $this->conn, $this->qtde_pockets, $this->uuid, $this->operador, $this->plataforma );
                break;
            
            case 'excluiLogado':
                $this->_excluiLogado( $this->app, $this->conn, $this->uuid, $this->operador );
                break;
                       
            default:
                $this->erro();

        }
        
        
        //Roda aplicação do SlimPHP Orientada a Objeto
        $this->app->run();
    
    }
    
        private function _verificacoesIniciais( $app, $debug, $version_api ){
        
        $app->get( '/', function() use( $app, $debug, $version_api ){
            
            if( $debug ){
                $os = 'mac'; 
            }else{
                $os = 'windows';
            }
            
            
            //conecta no banco com arquivo ConexaoLoja.xml
            if( $conn = $this->conectaBancoLocal( $os, $debug ) ){
                
                
                $this->__bd = $this->getMySQLi( $conn['host'], $conn['porta'], $conn['usuario'], $conn['senha'], $conn['nomebanco'] );
                mysqli_set_charset( $this->__bd, "utf8" ); 

                $ip = $_SERVER['REMOTE_ADDR'];

                
                if( $busca_device = $this->buscaDevicePorIP( $ip ) ){
                    
                    if( $busca_device['liberado'] == 'N' ){
                        
                        $this->__bd->close();
                        $this->rMsg( '010', "Este dispositivo de IP: $ip não está liberado.\n Adicione em Utilitários\Configuração de Dispositivos.", $busca_device );
                        
                    }else{
                        $numero_pocket  = $busca_device['palm'];
                        $qtde_pockets   = $busca_device['qtde_pockets'];
                        $usa_dispositivos_moveis_por_login   = $busca_device['usa_dispositivos_moveis_por_login'];
                        $checkin        = $busca_device['checkin'];
                        $liberacao_global = $busca_device['liberacao_global'];
                    }
                    
                }


                if( $num_mesas = $this->qtdMesas() ){
                    $mesas_ = $num_mesas['qtd_mesas'];
                    $url_imagem_logo = $num_mesas['url_imagem_logo'];
                }else{
                    $mesas_ = 0;
                    $url_imagem_logo = '';
                }

                if( $num_comandas = $this->qtdComandas() ){
                    $comandas_min = $num_comandas['comandas_min'];
                    $comandas_max = $num_comandas['comandas_max'];
                }else{
                    $comandas_min = 0;
                    $comandas_max = 0;
                }

                if( $identificadores_loja = $this->capturaRedeLoja() ){
                    $codigo_rede = $identificadores_loja['codigo_rede'];
                    $codigo_loja = $identificadores_loja['codigo_loja'];
                }
                
                if( $dados_pocket_socket = $this->dadosPocketMultisaborAndSocket() ){
                    
                    $versao = $dados_pocket_socket['versao_pocket'];
                    $data_limite_versao = $dados_pocket_socket['data_limite_atu_pocket'];
                    $porta_socket = $dados_pocket_socket['porta_socket'];
                    $ip_socket = $dados_pocket_socket['ip_socket'];
                    $usa_multisabor = $dados_pocket_socket['meia_pizza'];
                    $operacao_multisabor = $dados_pocket_socket['valor_pizza'];
                    $desconto_maximo = $dados_pocket_socket['desconto_maximo'];
                    $usa_justificativa_canc_item_mesa = $dados_pocket_socket['usa_justificativa_canc_item_mesa'];
                    $usa_justificativa_canc_item_comanda = $dados_pocket_socket['usa_justificativa_canc_item_comanda'];                    
                    $usa_pre_fechamento_individual = $dados_pocket_socket['usa_pre_fechamento_individual'];                    
                }

                if( $dados_mercado_pago = $this->dadosMercadoPago() ){
                    $usa_mercado_pago = $dados_mercado_pago['usa_mercado_pago'];
                    $token_mercado_pago = $dados_mercado_pago['token_mercado_pago'];
                    $store_id_mercado_pago = $dados_mercado_pago['store_id_mercado_pago'];

                }

                if( $dados_shipay = $this->dadosShipay() ){
                    $usa_shipay = $dados_shipay['usa_shipay'];
                    $access_key_shipay = $dados_shipay['access_key_shipay'];
                    $secret_key_shipay = $dados_shipay['secret_key_shipay'];
                    $cpf_cnpj_shipay = $dados_shipay['cpf_cnpj_shipay'];
                }

                if( $banners = $this->listaBanners() ){
                    $banners_ = $banners;
                }else{
                    $banners_ = array();
                }

                $res = array( "versao" => "$versao", 
                                "versao_api" => "$version_api", 
                                "data_limite_versao" => "$data_limite_versao", 
                                "numero_pocket" => "$numero_pocket", 
                                "checkin" => $checkin, 
                                "qtde_pockets" => $qtde_pockets,
                                "usa_dispositivos_moveis_por_login" => $usa_dispositivos_moveis_por_login,
                                "liberacao_global" => $liberacao_global, 
                                "desconto_maximo" => $desconto_maximo, 
                                "codigo_rede" => $codigo_rede, 
                                "codigo_loja" => $codigo_loja,  
                                "ip" => $ip, 
                                "usa_multisabor" => "$usa_multisabor",
                                "usa_justificativa_canc_item_mesa" => $usa_justificativa_canc_item_mesa,
                                "usa_justificativa_canc_item_comanda" => $usa_justificativa_canc_item_comanda, 
                                "operacao_multisabor" => "$operacao_multisabor", 
                                "comandas_min" => $comandas_min, 
                                "comandas_max" => $comandas_max, 
                                "mesas" => $mesas_, 
                                "url_imagem_logo" => $url_imagem_logo,
                                "banners" => $banners_,
                                "usa_pre_fechamento_individual" => $usa_pre_fechamento_individual,
                                "cielo" => array( 
                                        "clientID" => "NOQqVHORGcBeGgCvGVIG17BvCi5UvsjFgyiSOHAOhRxiI3jWfZ", 
                                        "accessToken" => "PHnqEMdKQitbMwICKqy3aZ0FBhFhu8e84XAVDtAxHd01vETudY"), 
                                        "mercado_pago" => array( 
                                            "usa_mercado_pago" => $usa_mercado_pago, 
                                            "token_mercado_pago" => $token_mercado_pago, 
                                            "store_id_mercado_pago" => $store_id_mercado_pago) , 
                                        "shipay" => array(
                                            "usa_shipay" => $usa_shipay,
                                            "access_key_shipay" => $access_key_shipay,
                                            "secret_key_shipay" => $secret_key_shipay,
                                            "cpf_cnpj_shipay" => $cpf_cnpj_shipay)
                                            ,
                                            "conexao_banco" => array(  
                                                "host" => $conn['host'], 
                                                "porta" => $conn['porta'], 
                                                "usuario" => $conn['usuario'], 
                                                "senha" => $conn['senha'], 
                                                "nomebanco" => $conn['nomebanco'], 
                                                "ip_socket" => "$ip_socket", 
                                                "porta_socket" => "$porta_socket" ) );

                if( $this->_externo ){
                    $res = array("versao_api" => "$version_api", "numero_pocket" => "$numero_pocket", "ip" => $ip, "usa_multisabor" => "$usa_multisabor", "operacao_multisabor" => "$operacao_multisabor", "comandas_min" => $comandas_min, "comandas_max" => $comandas_max, "mesas" => $mesas_, "url_imagem_logo" => $url_imagem_logo, "banners" => $banners_, "usa_justificativa_canc_item_mesa" => $usa_justificativa_canc_item_mesa,
                        "usa_justificativa_canc_item_comanda" => $usa_justificativa_canc_item_comanda);
                }
                
                $this->__bd->close();
                $this->rMsg( '000', 'Operação efetuada com sucesso', $res );
                
            }else{
                
                $this->__bd->close();
                $this->rMsg( '008', 'Falha ao ler ConexaoLoja.xml', 0 );
                
            }
            
        });
        
    }
    
    /***********************
     * INÍCIO METODOS SOCKET
     ***********************/
    
    private function _efetuaVenda( $app, $conn ){
        
        $app->post( '/', function () use( $app, $conn ){
            
            if( $this->debug ){ $conn = $this->conectaBancoLocal( 'mac', true ); }
            
            $efetuaVendaPOST = $app->request()->getBody();

            if($this->_externo){

                $conn = $this->conectaBancoLocal( 'mac', true );
                $this->__bd = $this->getMySQLi( $conn['host'], $conn['porta'], $conn['usuario'], $conn['senha'], $conn['nomebanco'] );mysqli_set_charset( $this->__bd, "utf8" );

                //$this->gravaTXT( $efetuaVendaPOST, 'json_recebido' );
                $json = json_decode($efetuaVendaPOST);
                
                //$this->gravaTXT( 'ok', 'apos_decode_JSON' );

                $tipo_operacao = $json[0]->JSON->tipo_operacao;
                $numero = $json[0]->JSON->numero;

                if( $tipo_operacao == 'mesa' ){

                    if( $pre_fechamento = $this->consultaMesaPreFechamento( $numero ) ){
                
                        if( $pre_fechamento['motivo'] == 'inexistente' ){
                            $this->__bd->close();
                            $this->rMsg( '004', 'Mesa não encontrada', 0 );
                        }
                        
                        $this->__bd->close();
                        $this->rMsg( '003', 'Mesa em Pré Fechamento', 0 );
                        
                    }
                }

                
                //$this->gravaTXT( 'ok', 'antes_do_select' );
                $socket = $this->dadosPocketMultisaborAndSocket();
                $conn['ip_socket'] = $socket['ip_socket'];
                $conn['porta_socket'] = $socket['porta_socket'];
                //$this->gravaTXT( 'ip: ' . $socket['ip_socket'] . ' - porta: ' . $socket['porta_socket'] , 'apos_select' );

                if( $res = $this->efetuaVendaExterno( $efetuaVendaPOST, $conn['ip_socket'], $conn['porta_socket'] ) ){
                
                    //$this->gravaTXT( 'ok', 'apos_socket_efetuaVenda' );
                    if( $res == 'offline' ){
                        
                        $motivo['motivo'] = '';
                        $this->rMsg( '006', 'Falha ao estabelecer comunicação com o socket de IP: ' . $conn['ip_socket'] . ' - Verifique se o Monitor esta aberto', $motivo );
                        
                    }else{
                        
                        echo $res;
                        exit();
                        //$this->rMsg( '000', 'Operação efetuada com sucesso', $res );
                        
                    }
                
                }else{
                    $this->rMsg( '999', 'Falha na operação', 0 );
                    
                }

            }else{

                if( $res = $this->efetuaVenda( $efetuaVendaPOST, $conn['ip_socket'], $conn['porta_socket'] ) ){
                
                    //$this->gravaTXT( 'ok', 'apos_socket_efetuaVenda' );
                    if( $res == 'offline' ){
                        
                        $motivo['motivo'] = '';
                        $this->rMsg( '006', 'Falha ao estabelecer comunicação com o socket de IP: ' . $conn['ip_socket'] . ' - Verifique se o Monitor esta aberto', $motivo );
                        
                    }else{
                        
                        echo $res;
                        exit();
                        //$this->rMsg( '000', 'Operação efetuada com sucesso', $res );
                        
                    }
                
                }else{
                    $this->rMsg( '999', 'Falha na operação', 0 );
                    
                }

            }
            
            
            
        });
    }
    
    private function _cancelaItens( $app, $conn, $operacao, $mesa_comanda ){
        
        $app->post( '/', function () use( $app, $conn, $operacao, $mesa_comanda ){
            
            if( $this->debug ){ $conn = $this->conectaBancoLocal( 'mac', true ); }
            
            $cancelaItensPOST = $app->request()->getBody();

            if($this->_externo){

                $conn = $this->conectaBancoLocal( 'mac', true );
                $this->__bd = $this->getMySQLi( $conn['host'], $conn['porta'], $conn['usuario'], $conn['senha'], $conn['nomebanco'] );mysqli_set_charset( $this->__bd, "utf8" );

                $socket = $this->dadosPocketMultisaborAndSocket();
                $conn['ip_socket'] = $socket['ip_socket'];
                $conn['porta_socket'] = $socket['porta_socket'];
            }
            
            if( $res = $this->cancelaItens( $cancelaItensPOST, $conn['ip_socket'], $conn['porta_socket'] ) ){
               
                if( $res == 'offline' ){
                    
                    $motivo['motivo'] = '';
                    $this->rMsg( '006', 'Falha ao estabelecer comunicação com o socket de IP: ' . $conn['ip_socket'] . ' - Verifique se o Monitor esta aberto', $motivo );
                    
                }else{
                    
                    echo $res;
                    exit();
                    
                }
                
            }else{
                $this->rMsg( '999', 'Falha na operação', 0 );
                
            }
            
        });
    }
    
    private function _cancelaRequisicaoMercadoPago( $app, $conn ){
        
        $app->post( '/', function () use( $app, $conn ){

            if( $this->debug ){ $conn = $this->conectaBancoLocal( 'mac', true ); }
            
            $cancelaRequisicaoPOST = $app->request()->getBody();

            if($this->_externo){

                $conn = $this->conectaBancoLocal( 'mac', true );
                $this->__bd = $this->getMySQLi( $conn['host'], $conn['porta'], $conn['usuario'], $conn['senha'], $conn['nomebanco'] );mysqli_set_charset( $this->__bd, "utf8" );

                $socket = $this->dadosPocketMultisaborAndSocket();
                $conn['ip_socket'] = $socket['ip_socket'];
                $conn['porta_socket'] = $socket['porta_socket'];
            }

            if( $res = $this->cancelaRequisicaoMercadoPago( $cancelaRequisicaoPOST, $conn['ip_socket'], $conn['porta_socket'] ) ){
               
                if( $res == 'offline' ){
                    $motivo['motivo'] = '';
                    $this->rMsg( '006', 'Falha ao estabelecer comunicação com o socket de IP: ' . $conn['ip_socket'] . ' - Verifique se o Monitor esta aberto', $motivo );
                }else{
                    echo $res;
                    exit();                    
                }
                
            }else{
                $this->rMsg( '999', 'Falha na operação', 0 );
                
            }
            
        });
    }


    private function _transfereItens( $app, $conn, $operacao, $origem, $destino ){
        
        $app->post( '/', function () use( $app, $conn, $operacao, $origem, $destino ){
            
            if( $this->debug ){ $conn = $this->conectaBancoLocal( 'mac', true ); }
            
            $transfereItensPOST = $app->request()->getBody();

            if($this->_externo){

                $conn = $this->conectaBancoLocal( 'mac', true );
                $this->__bd = $this->getMySQLi( $conn['host'], $conn['porta'], $conn['usuario'], $conn['senha'], $conn['nomebanco'] );mysqli_set_charset( $this->__bd, "utf8" );

                $socket = $this->dadosPocketMultisaborAndSocket();
                $conn['ip_socket'] = $socket['ip_socket'];
                $conn['porta_socket'] = $socket['porta_socket'];
            }
            
            if( $res = $this->transfereItens( $transfereItensPOST, $conn['ip_socket'], $conn['porta_socket'] ) ){
                
                if( $res == 'offline' ){
                    
                    $motivo['motivo'] = '';
                    $this->rMsg( '006', 'Falha ao estabelecer comunicação com o socket de IP: ' . $conn['ip_socket'] . ' - Verifique se o Monitor esta aberto', $motivo );
                    
                }else{
                    
                    echo $res;
                    exit();
                    
                }
                
            }else{
                $this->rMsg( '999', 'Falha na operação', 0 );
                
            }
            
        });
    }
    
    
    private function _enviaPreFechamento( $app, $conn, $operacao, $mesa_comanda ){
        
        $app->post( '/', function () use( $app, $conn, $operacao, $mesa_comanda ){
            
            if( $this->debug ){ $conn = $this->conectaBancoLocal( 'mac', true ); }
            
            $enviaPreFechamentoPOST = $app->request()->getBody();

            if($this->_externo){

                $conn = $this->conectaBancoLocal( 'mac', true );
                $this->__bd = $this->getMySQLi( $conn['host'], $conn['porta'], $conn['usuario'], $conn['senha'], $conn['nomebanco'] );mysqli_set_charset( $this->__bd, "utf8" );

                $socket = $this->dadosPocketMultisaborAndSocket();
                $conn['ip_socket'] = $socket['ip_socket'];
                $conn['porta_socket'] = $socket['porta_socket'];
            }
            
            if( $res = $this->enviaPreFechamento( $enviaPreFechamentoPOST, $conn['ip_socket'], $conn['porta_socket'] ) ){
                
                if( $res == 'offline' ){
                    
                    $motivo['motivo'] = '';
                    $this->rMsg( '006', 'Falha ao estabelecer comunicação com o socket de IP: ' . $conn['ip_socket'] . ' - Verifique se o Monitor esta aberto', $motivo );
                    
                }else{
                    
                    echo $res;
                    exit();
                    
                }
                
            }else{
                $this->rMsg( '999', 'Falha na operação', 0 );
                
            }
            
            
            
        });
    }
    
    
    private function _fecharConta( $app, $conn ){
        
        $app->post( '/', function () use( $app, $conn ){
            
            if( $this->debug ){ $conn = $this->conectaBancoLocal( 'mac', true ); }
            
            $fecharContaPOST = $app->request()->getBody();

            if($this->_externo){

                $conn = $this->conectaBancoLocal( 'mac', true );
                $this->__bd = $this->getMySQLi( $conn['host'], $conn['porta'], $conn['usuario'], $conn['senha'], $conn['nomebanco'] );mysqli_set_charset( $this->__bd, "utf8" );

                $socket = $this->dadosPocketMultisaborAndSocket();
                $conn['ip_socket'] = $socket['ip_socket'];
                $conn['porta_socket'] = $socket['porta_socket'];
            }
            
            if( $res = $this->fecharConta( $fecharContaPOST, $conn['ip_socket'], $conn['porta_socket'] ) ){
                
                if( $res == 'offline' ){
                    
                    $motivo['motivo'] = '';
                    $this->rMsg( '006', 'Falha ao estabelecer comunicação com o socket de IP: ' . $conn['ip_socket'] . ' - Verifique se o Monitor esta aberto', $motivo );
                    
                }else{
                    
                    echo $res;
                    exit();
                    
                }
                
            }else{
                $this->rMsg( '999', 'Falha na operação', 0 );
                
            }
            
        });
    }


     private function _chamarGarcom( $app, $conn ){
        
        $app->post( '/', function () use( $app, $conn ){
            
            if( $this->debug ){ $conn = $this->conectaBancoLocal( 'mac', true ); }
            
            $chamarGarcomPOST = $app->request()->getBody();

            if($this->_externo){

                $conn = $this->conectaBancoLocal( 'mac', true );
                $this->__bd = $this->getMySQLi( $conn['host'], $conn['porta'], $conn['usuario'], $conn['senha'], $conn['nomebanco'] );mysqli_set_charset( $this->__bd, "utf8" );

                $socket = $this->dadosPocketMultisaborAndSocket();
                $conn['ip_socket'] = $socket['ip_socket'];
                $conn['porta_socket'] = $socket['porta_socket'];
            }
            
            if( $res = $this->chamarGarcom( $chamarGarcomPOST, $conn['ip_socket'], $conn['porta_socket'] ) ){
                
                if( $res == 'offline' ){
                    
                    $motivo['motivo'] = '';
                    $this->rMsg( '006', 'Falha ao estabelecer comunicação com o socket de IP: ' . $conn['ip_socket'] . ' - Verifique se o Monitor esta aberto', $motivo );
                    
                }else{
                    
                    echo $res;
                    exit();
                    
                }
                
            }else{
                $this->rMsg( '999', 'Falha na operação', 0 );
                
            }
            
        });
    }


    private function _consultaTotalConta( $app, $conn ){
        
        $app->post( '/', function () use( $app, $conn ){
            
            if( $this->debug ){ $conn = $this->conectaBancoLocal( 'mac', true ); }
            
            $consultaTotalContaPOST = $app->request()->getBody();

            if($this->_externo){

                $conn = $this->conectaBancoLocal( 'mac', true );
                $this->__bd = $this->getMySQLi( $conn['host'], $conn['porta'], $conn['usuario'], $conn['senha'], $conn['nomebanco'] );mysqli_set_charset( $this->__bd, "utf8" );

                $socket = $this->dadosPocketMultisaborAndSocket();
                $conn['ip_socket'] = $socket['ip_socket'];
                $conn['porta_socket'] = $socket['porta_socket'];
            }
            
            if( $res = $this->consultaTotalConta( $consultaTotalContaPOST, $conn['ip_socket'], $conn['porta_socket'] ) ){
                
                if( $res == 'offline' ){
                    
                    $motivo['motivo'] = '';
                    $this->rMsg( '006', 'Falha ao estabelecer comunicação com o socket de IP: ' . $conn['ip_socket'] . ' - Verifique se o Monitor esta aberto', $motivo );
                    
                }else{
                    
                    echo $res;
                    exit();
                    
                }
                
            }else{
                $this->rMsg( '999', 'Falha na operação', 0 );
                
            }
            
        });
    }


    private function _cancelaVenda( $app, $conn ){
        
        $app->post( '/', function () use( $app, $conn ){
            
            if( $this->debug ){ $conn = $this->conectaBancoLocal( 'mac', true ); }
            
            $cancelaVendaPOST = $app->request()->getBody();

            if($this->_externo){

                $conn = $this->conectaBancoLocal( 'mac', true );
                $this->__bd = $this->getMySQLi( $conn['host'], $conn['porta'], $conn['usuario'], $conn['senha'], $conn['nomebanco'] );mysqli_set_charset( $this->__bd, "utf8" );

                $socket = $this->dadosPocketMultisaborAndSocket();
                $conn['ip_socket'] = $socket['ip_socket'];
                $conn['porta_socket'] = $socket['porta_socket'];
            }
            
            if( $res = $this->cancelaVenda( $cancelaVendaPOST, $conn['ip_socket'], $conn['porta_socket'] ) ){
                
                if( $res == 'offline' ){
                    
                    $motivo['motivo'] = '';
                    $this->rMsg( '006', 'Falha ao estabelecer comunicação com o socket de IP: ' . $conn['ip_socket'] . ' - Verifique se o Monitor esta aberto', $motivo );
                    
                }else{
                    
                    echo $res;
                    exit();
                    
                }
                
            }else{
                $this->rMsg( '999', 'Falha na operação', 0 );
                
            }
            
        });
    }

    private function _gravaTXT( $app, $nome_arquivo, $conn ){
        
        $app->post( '/', function () use( $app, $nome_arquivo, $conn ){
            
            $json = $app->request()->getBody();
            
            if( $res = $this->gravaTXT( $json, $nome_arquivo ) ){
                
                $this->rMsg( '000', 'Operação efetuada com sucesso', 0 );
                
            }else{
                $this->rMsg( '999', 'Falha na operação', 0 );
                
            }
            
        });
    }

    /***********************
     * FIM METODOS SOCKET
     ***********************/

    private function _gravaCheckin($app, $conn){
        $app->post( '/', function () use( $app, $conn){

            if( $this->debug || $this->_externo ){ $conn = $this->conectaBancoLocal( 'mac', true ); }

            $gravaCheckinPOST = $app->request()->getBody();

            $this->__bd = $this->getMySQLi( $conn['host'], $conn['porta'], $conn['usuario'], $conn['senha'], $conn['nomebanco'] );
            mysqli_set_charset($this->__bd, "utf8");

            if($res = $this->gravaCheckin( $gravaCheckinPOST ) ){
                
                $this->__bd->close();
                $this->rMsg( '000', 'Operação efetuada com sucesso', 0 );
                
            }else{
                $this->__bd->close();
                $this->rMsg( '999', 'Falha na operação', 0 );
            }
        });
    }


    private function _consultaMesaPreFechamento( $app, $mesa, $conn ){
        
        $app->get( '/', function () use( $app, $mesa, $conn ){
            
            if( $this->debug || $this->_externo ){ $conn = $this->conectaBancoLocal( 'mac', true ); }
            $this->__bd = $this->getMySQLi( $conn['host'], $conn['porta'], $conn['usuario'], $conn['senha'], $conn['nomebanco'] );mysqli_set_charset( $this->__bd, "utf8" );
            
            if( $pre_fechamento = $this->consultaMesaPreFechamento( $mesa ) ){
                
                if( $pre_fechamento['motivo'] == 'inexistente' ){
                    $this->__bd->close();
                    $this->rMsg( '004', 'Mesa não encontrada', $res );
                }
                
                $this->__bd->close();
                $this->rMsg( '003', 'Mesa em Pré Fechamento', 0 );
                
            }else{
                
                $this->__bd->close();
                $this->rMsg( '000', 'Operação efetuada com sucesso', 0 );
                
            }
        });
    }
    
    private function _consultaComandaBloqueada( $app, $comanda, $usa_checkin, $conn ){
        
        $app->get( '/', function () use( $app, $comanda, $usa_checkin, $conn ){
            
            if( $this->debug || $this->_externo ){ $conn = $this->conectaBancoLocal( 'mac', true ); }
            $this->__bd = $this->getMySQLi( $conn['host'], $conn['porta'], $conn['usuario'], $conn['senha'], $conn['nomebanco'] );mysqli_set_charset( $this->__bd, "utf8" );

            if( $bloqueada = $this->consultaComandaBloqueada( $comanda, $usa_checkin ) ){
                
                if( $bloqueada['motivo'] == 'inexistente' ){
                    $this->__bd->close();
                    $this->rMsg( '005', 'Comanda não encontrada' );
                }
                
                if( $bloqueada['motivo'] == 'vinculada' ){
                    $this->__bd->close();
                    $this->rMsg('000' , 'Operação efetuada com sucesso', $bloqueada);
                }
                
                $res['bloqueada'] = $bloqueada;
                $this->__bd->close();
                $this->rMsg( '002', 'Comanda bloqueada', $res );
                
            }else{
                
                $this->__bd->close();
                $this->rMsg( '000', 'Operação efetuada com sucesso', 0 );
                
            }
            
        });
    }
    
    private function _consultaItens( $app, $conn, $operacao, $mesa_comanda ){
        
        $app->get( '/', function () use( $app, $conn, $operacao, $mesa_comanda ){
            
            if( $this->debug || $this->_externo ){ $conn = $this->conectaBancoLocal( 'mac', true ); }
            $this->__bd = $this->getMySQLi( $conn['host'], $conn['porta'], $conn['usuario'], $conn['senha'], $conn['nomebanco'] );mysqli_set_charset( $this->__bd, "utf8" );

            if( $rItens = $this->consultaItens( $operacao, $mesa_comanda ) ){
                $res['itens'] = $rItens;
            }else{
                $res['itens'] = "";
            }
            
            $this->__bd->close();
            
            $this->rMsg( '000', 'Operação efetuada com sucesso', $res );
            
        });
        
    }
    
    
    private function _consultaCliente( $app, $conn, $numero, $tipo_consulta ){
        
        $app->get( '/', function () use( $app, $conn, $numero, $tipo_consulta ){
            
            if( $this->debug || $this->_externo ){ $conn = $this->conectaBancoLocal( 'mac', true ); }
            $this->__bd = $this->getMySQLi( $conn['host'], $conn['porta'], $conn['usuario'], $conn['senha'], $conn['nomebanco'] );mysqli_set_charset( $this->__bd, "utf8" );

            if( $rCliente = $this->consultaCliente( $numero, $tipo_consulta ) ){
                
                $res['cliente'] = $rCliente;
                
                $this->__bd->close();
                $this->rMsg( '000', 'Operação efetuada com sucesso', $res );
                
            }else{
                $this->__bd->close();
                $this->rMsg( '999', 'Falha na operação', 0 );
            }
        });
            
    }
    
    
    private function _mapaDeMesas( $app, $conn ){
        
        $app->get( '/', function () use( $app, $conn ){
            
            if( $this->debug || $this->_externo ){ $conn = $this->conectaBancoLocal( 'mac', true ); }
            $this->__bd = $this->getMySQLi( $conn['host'], $conn['porta'], $conn['usuario'], $conn['senha'], $conn['nomebanco'] );mysqli_set_charset( $this->__bd, "utf8" );

            if( $rMesas = $this->mapaDeMesas() ){
                
                $res['mesas'] = $rMesas;
                
                $this->__bd->close();
                $this->rMsg( '000', 'Operação efetuada com sucesso', $res );
                
            }else{
                $this->__bd->close();
                $this->rMsg( '999', 'Falha na operação', 0 );
            }
        });
    }
    
    
    private function _mapaDeComandas( $app, $conn ){
        
        $app->get( '/', function () use( $app, $conn ){
            
            if( $this->debug || $this->_externo ){ $conn = $this->conectaBancoLocal( 'mac', true ); }
            $this->__bd = $this->getMySQLi( $conn['host'], $conn['porta'], $conn['usuario'], $conn['senha'], $conn['nomebanco'] );mysqli_set_charset( $this->__bd, "utf8" );

            if( $rComandas = $this->mapaDeComandas() ){
                
                $res['comandas'] = $rComandas;
                
                $this->__bd->close();
                $this->rMsg( '000', 'Operação efetuada com sucesso', $res );
                
            }else{
                $this->__bd->close();
                $this->rMsg( '999', 'Falha na operação', 0 );
            }
        });
    }
    
    
    private function _listaGrupos( $app, $conn, $numero_pocket=0 ){
        
        $app->get( '/', function () use( $app, $conn, $numero_pocket ){
            
            if( $this->debug || $this->_externo ){ $conn = $this->conectaBancoLocal( 'mac', true ); }
            $this->__bd = $this->getMySQLi( $conn['host'], $conn['porta'], $conn['usuario'], $conn['senha'], $conn['nomebanco'] );mysqli_set_charset( $this->__bd, "utf8" );
            
            if( $grupos = $this->listaGrupos( $numero_pocket ) ){
                $res['colecao'] = $grupos;
            }else{
                $res['colecao'] = "";
            }


            $this->__bd->close();
            $this->rMsg( '000', 'Operação efetuada com sucesso', $res );
                
        });
    }
    
    
    private function _listaProdutos( $app, $conn, $num_pocket ){
        
        $app->get( '/', function () use( $app, $conn, $num_pocket ){
            
           if( $this->debug || $this->_externo ){ $conn = $this->conectaBancoLocal( 'mac', true ); }
            $this->__bd = $this->getMySQLi( $conn['host'], $conn['porta'], $conn['usuario'], $conn['senha'], $conn['nomebanco'] );mysqli_set_charset( $this->__bd, "utf8" );
            
            if( $produtos = $this->listaProdutos( $num_pocket ) ){
                $res['produtos'] = $produtos;
            }else{
                $res['produtos'] = "";
            }

            $this->__bd->close();
            $this->rMsg( '000', 'Operação efetuada com sucesso', $res );
            
        });
    }
    
    private function _listaProdutosEscondidos( $app, $conn, $num_pocket ){
        
        $app->get( '/', function () use( $app, $conn, $num_pocket ){
            
           if( $this->debug || $this->_externo ){ $conn = $this->conectaBancoLocal( 'mac', true ); }
            $this->__bd = $this->getMySQLi( $conn['host'], $conn['porta'], $conn['usuario'], $conn['senha'], $conn['nomebanco'] );mysqli_set_charset( $this->__bd, "utf8" );
            
            if( $produtos = $this->listaProdutosEscondidos( $num_pocket ) ){
                $res['produtos_escondidos'] = $produtos;
            }else{
                $res['produtos_escondidos'] = "";
            }

            $this->__bd->close();
            $this->rMsg( '000', 'Operação efetuada com sucesso', $res );
            
        });
    }
    
    
    private function _listaCombos( $app, $conn ){
        
        $app->get( '/', function () use( $app, $conn ){
           
            if( $this->debug || $this->_externo ){ $conn = $this->conectaBancoLocal( 'mac', true ); }
            $this->__bd = $this->getMySQLi( $conn['host'], $conn['porta'], $conn['usuario'], $conn['senha'], $conn['nomebanco'] );mysqli_set_charset( $this->__bd, "utf8" );
            
            if( $combos = $this->listaCombos() ){
                $res['combos'] = $combos;
            }else{
                $res['combos'] = "";
            }

            $this->__bd->close();
            $this->rMsg( '000', 'Operação efetuada com sucesso', $res );
            
        });
    }

    private function _listaPizzas( $app, $conn ){
        
        $app->get( '/', function () use( $app, $conn ){
           
            if( $this->debug || $this->_externo ){ $conn = $this->conectaBancoLocal( 'mac', true ); }
            $this->__bd = $this->getMySQLi( $conn['host'], $conn['porta'], $conn['usuario'], $conn['senha'], $conn['nomebanco'] );mysqli_set_charset( $this->__bd, "utf8" );
            
            if( $pizzas = $this->listaPizzas() ){
                $res['pizzas'] = $pizzas;
            }else{
                $res['pizzas'] = "";
            }

            $this->__bd->close();
            $this->rMsg( '000', 'Operação efetuada com sucesso', $res );
            
        });
    }
    
    private function _listaTipoClientes( $app, $conn ){
        
        $app->get( '/', function () use( $app, $conn ){
           
            if( $this->debug || $this->_externo ){ $conn = $this->conectaBancoLocal( 'mac', true ); }
            $this->__bd = $this->getMySQLi( $conn['host'], $conn['porta'], $conn['usuario'], $conn['senha'], $conn['nomebanco'] );mysqli_set_charset( $this->__bd, "utf8" );
            
            if( $tipo_clientes = $this->listaTipoClientes() ){
                $res['tipo_clientes'] = $tipo_clientes;
            }else{
                $res['tipo_clientes'] = "";
            }

            $this->__bd->close();
            $this->rMsg( '000', 'Operação efetuada com sucesso', $res );
            
        });
    }
    
    
    private function _listaProdutosFaltantes( $app, $conn ){
        
        $app->get( '/', function () use( $app, $conn ){
           
            if( $this->debug || $this->_externo ){ $conn = $this->conectaBancoLocal( 'mac', true ); }
            $this->__bd = $this->getMySQLi( $conn['host'], $conn['porta'], $conn['usuario'], $conn['senha'], $conn['nomebanco'] );mysqli_set_charset( $this->__bd, "utf8" );
            
            if( $faltantes = $this->listaProdutosFaltantes() ){
                $res['produtos_faltantes'] = $faltantes;
            }else{
                $res['produtos_faltantes'] = "";
            }

            $this->__bd->close();
            $this->rMsg( '000', 'Operação efetuada com sucesso', $res );
            
        });
    }
    
    
    private function _listaProdutosVinculados( $app, $conn ){
        
        $app->get( '/', function () use( $app, $conn ){
           
            if( $this->debug || $this->_externo ){ $conn = $this->conectaBancoLocal( 'mac', true ); }
            $this->__bd = $this->getMySQLi( $conn['host'], $conn['porta'], $conn['usuario'], $conn['senha'], $conn['nomebanco'] );mysqli_set_charset( $this->__bd, "utf8" );
            
            if( $vinculados = $this->listaProdutosVinculados() ){
                $res['produtos_vinculados'] = $vinculados;
            }else{
                $res['produtos_vinculados'] = "";
            }

            $this->__bd->close();
            $this->rMsg( '000', 'Operação efetuada com sucesso', $res );
            
        });
    }

    private function _listaProdutosTemporarios( $app, $conn ){
        
        $app->get( '/', function () use( $app, $conn ){
           
            if( $this->debug || $this->_externo ){ $conn = $this->conectaBancoLocal( 'mac', true ); }
            $this->__bd = $this->getMySQLi( $conn['host'], $conn['porta'], $conn['usuario'], $conn['senha'], $conn['nomebanco'] );mysqli_set_charset( $this->__bd, "utf8" );
            
            if( $produtos_temporarios = $this->listaProdutosTemporarios() ){
                $res['produtos_temporarios'] = $produtos_temporarios;
            }else{
                $res['produtos_temporarios'] = "";
            }

            $this->__bd->close();
            $this->rMsg( '000', 'Operação efetuada com sucesso', $res );
            
        });
    }
    
    
    private function _listaPromocoes( $app, $conn ){
        
        $app->get( '/', function () use( $app, $conn ){
            
           if( $this->debug || $this->_externo ){ $conn = $this->conectaBancoLocal( 'mac', true ); }
            $this->__bd = $this->getMySQLi( $conn['host'], $conn['porta'], $conn['usuario'], $conn['senha'], $conn['nomebanco'] );mysqli_set_charset( $this->__bd, "utf8" );
            
            if( $promocoes = $this->listaPromocoes() ){
                $res['promocoes'] = $promocoes;
            }else{
                $res['promocoes'] = "";
            }

            if( $multipreco = $this->listaMultiPreco() ){
                $res['multipreco'] = $multipreco;
            }else{
                $res['multipreco'] = "";
            }


            $this->__bd->close();
            $this->rMsg( '000', 'Operação efetuada com sucesso', $res );
            
        });
    }
    
    private function _listaDetalheBandeiras( $app, $conn ){
        
        $app->get( '/', function () use( $app, $conn ){
            
           if( $this->debug || $this->_externo ){ $conn = $this->conectaBancoLocal( 'mac', true ); }
            $this->__bd = $this->getMySQLi( $conn['host'], $conn['porta'], $conn['usuario'], $conn['senha'], $conn['nomebanco'] );mysqli_set_charset( $this->__bd, "utf8" );
            
            if( $bandeiras = $this->listaDetalheBandeiras() ){
                $res['bandeiras'] = $bandeiras;
            }else{
                $res['bandeiras'] = "";
            }

            $this->__bd->close();
            $this->rMsg( '000', 'Operação efetuada com sucesso', $res );
            
        });
    }

    
    private function _listaOperadores( $app, $operacao, $conn ){
        
        $app->get( '/', function () use( $app, $operacao, $conn ){
            
            if( $this->debug || $this->_externo ){ $conn = $this->conectaBancoLocal('mac', true); }
            $this->__bd = $this->getMySQLi( $conn['host'], $conn['porta'], $conn['usuario'], $conn['senha'], $conn['nomebanco'] );mysqli_set_charset( $this->__bd, "utf8" );
            
            if( $operadores = $this->listaOperadores( $operacao ) ){
                $res['operadores'] = $operadores;
            }else{
                $res['operadores'] = "";
            }

            $this->__bd->close();
            $this->rMsg( '000', 'Operação efetuada com sucesso', $res );
                
        });
    }

    private function _listaJustificativasCancelamento( $app, $conn ){
        
        $app->get( '/', function () use( $app, $operacao, $conn ){
            
            if( $this->debug || $this->_externo ){ $conn = $this->conectaBancoLocal('mac', true); }
            $this->__bd = $this->getMySQLi( $conn['host'], $conn['porta'], $conn['usuario'], $conn['senha'], $conn['nomebanco'] );mysqli_set_charset( $this->__bd, "utf8" );
            
            if( $justificativas = $this->listaJustificativasCancelamento() ){
                $res['justificativas_cancelamento'] = $justificativas;
            }else{
                $res['justificativas_cancelamento'] = "";
            }

            $this->__bd->close();
            $this->rMsg( '000', 'Operação efetuada com sucesso', $res );
                
        });
    }


    private function _listaTiposDeDesconto( $app, $conn ){
        
        $app->get( '/', function () use( $app, $operacao, $conn ){
            
            if( $this->debug || $this->_externo ){ $conn = $this->conectaBancoLocal('mac', true); }
            $this->__bd = $this->getMySQLi( $conn['host'], $conn['porta'], $conn['usuario'], $conn['senha'], $conn['nomebanco'] );mysqli_set_charset( $this->__bd, "utf8" );
            
            if( $tipos_descontos = $this->listaTiposDescontos() ){
                $res['tipos_de_descontos'] = $tipos_descontos;
            }else{
                $res['tipos_de_descontos'] = "";
            }

            $this->__bd->close();
            $this->rMsg( '000', 'Operação efetuada com sucesso', $res );
                
        });
    }


    private function _getIP( $app ){
        
        $app->get( '/', function () use( $app ){

            $ip = $_SERVER['REMOTE_ADDR'];
            $res['ip'] = $ip;

            $this->rMsg( '000', 'Operação efetuada com sucesso', $res );
                
        });
    }


    private function _imprimeDiversosPDV( $app, $conn ){
        
        $app->post( '/', function () use( $app, $conn ){
            
            if( $this->debug ){ $conn = $this->conectaBancoLocal( 'mac', true ); }
            
            $imprimeDiversosPDVPOST = $app->request()->getBody();

            if($this->_externo){

                $conn = $this->conectaBancoLocal( 'mac', true );
                $this->__bd = $this->getMySQLi( $conn['host'], $conn['porta'], $conn['usuario'], $conn['senha'], $conn['nomebanco'] );mysqli_set_charset( $this->__bd, "utf8" );

                $socket = $this->dadosPocketMultisaborAndSocket();
                $conn['ip_socket'] = $socket['ip_socket'];
                $conn['porta_socket'] = $socket['porta_socket'];
            }
            
            if( $res = $this->imprimeDiversosPDV( $imprimeDiversosPDVPOST, $conn['ip_socket'], $conn['porta_socket'] ) ){
                
                if( $res == 'offline' ){
                    
                    $motivo['motivo'] = '';
                    $this->rMsg( '006', 'Falha ao estabelecer comunicação com o socket de IP: ' . $conn['ip_socket'] . ' - Verifique se o Monitor esta aberto', $motivo );
                    
                }else{
                    
                    echo $res;
                    exit();
                    
                }
                
            }else{
                $this->rMsg( '999', 'Falha na operação', 0 );
                
            }
            
        });
    }
    


    private function _verificaLogin( $app, $conn, $qtde_pockets, $uuid, $nome_operador, $plataforma ){
        
        $app->get( '/', function () use( $app, $conn, $qtde_pockets, $uuid, $nome_operador, $plataforma ){

            if( $this->debug || $this->_externo ){ $conn = $this->conectaBancoLocal('mac', true); }
            $this->__bd = $this->getMySQLi( $conn['host'], $conn['porta'], $conn['usuario'], $conn['senha'], $conn['nomebanco'] );mysqli_set_charset( $this->__bd, "utf8" );

            if( $login = $this->verificaLogin( $qtde_pockets, $uuid, $nome_operador, $plataforma ) ){
                
                $res['logado'] = true;
            }else{
                
                $res['logado'] = false;
            }

            $this->__bd->close();
            $this->rMsg( '000', 'Operação efetuada com sucesso', $res );
                
        });
    }


    private function _excluiLogado( $app, $conn, $uuid, $nome_operador ){
        
        $app->get( '/', function () use( $app, $conn, $uuid, $nome_operador ){

            if( $this->debug || $this->_externo ){ $conn = $this->conectaBancoLocal('mac', true); }
            $this->__bd = $this->getMySQLi( $conn['host'], $conn['porta'], $conn['usuario'], $conn['senha'], $conn['nomebanco'] );mysqli_set_charset( $this->__bd, "utf8" );

            if( $excluido = $this->excluiLogado( $uuid, $nome_operador ) ){
                
                $res['excluido'] = true;
            }else{
                
                $res['excluido'] = false;
            }

            $this->__bd->close();
            $this->rMsg( '000', 'Operação efetuada com sucesso', $res );
                
        });
    }
    
    // Se o consumidor errar o nome do método irá cair nesta exceção
    private function erro(){
        die('Método inexistente');
    }
}

$wsCadastro = new services();